/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import net.adventurez.entity.VoidShadowEntity;
import net.adventurez.entity.model.VoidShadowModel;
import net.adventurez.entity.render.feature.VoidShadowBlackFeatureRenderer;
import net.adventurez.entity.render.feature.VoidShadowEyesFeatureRenderer;
import net.adventurez.init.RenderInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class VoidShadowRenderer
extends MobRenderer<VoidShadowEntity, VoidShadowModel<VoidShadowEntity>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("adventurez:textures/entity/void_shadow.png");

    public VoidShadowRenderer(EntityRendererProvider.Context context) {
        super(context, new VoidShadowModel(context.m_174023_(RenderInit.VOID_SHADOW_LAYER)), 1.7f);
        this.m_115326_(new VoidShadowEyesFeatureRenderer((RenderLayerParent<VoidShadowEntity, VoidShadowModel<VoidShadowEntity>>)this));
        this.m_115326_(new VoidShadowBlackFeatureRenderer((RenderLayerParent<VoidShadowEntity, VoidShadowModel<VoidShadowEntity>>)this));
    }

    public void scale(VoidShadowEntity voidShadowEntity, PoseStack matrixStack, float f) {
        matrixStack.m_85841_(9.0f, 9.0f, 9.0f);
    }

    public ResourceLocation getTexture(VoidShadowEntity voidShadowEntity) {
        return TEXTURE;
    }

    public void render(VoidShadowEntity voidShadowEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        if (voidShadowEntity.ticksSinceDeath > 40) {
            matrixStack.m_85836_();
            VertexConsumer vertexConsumer2 = vertexConsumerProvider.m_6299_(RenderType.m_110479_((ResourceLocation)TEXTURE));
            ((VoidShadowModel)this.f_115290_).m_7695_(matrixStack, vertexConsumer2, i, OverlayTexture.m_118090_((float)0.0f, (boolean)false), 1.0f, 1.0f, 1.0f, 1.0f);
            float l = ((float)voidShadowEntity.ticksSinceDeath + g) / 200.0f;
            float m = Math.min(l > 0.8f ? (l - 0.8f) / 0.2f : 0.0f, 1.0f);
            Random random = new Random(432L);
            VertexConsumer vertexConsumer5 = vertexConsumerProvider.m_6299_(RenderType.m_110502_());
            matrixStack.m_85837_(0.0, 5.0, 0.0);
            int n = 0;
            while ((float)n < (l + l * l) / 2.0f * 60.0f) {
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
                matrixStack.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f));
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
                matrixStack.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f + l * 90.0f));
                float o = random.nextFloat() * 20.0f + 5.0f + m * 10.0f;
                float p = random.nextFloat() * 2.0f + 1.0f + m * 2.0f;
                Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
                int q = (int)(255.0f * (1.0f - m));
                VoidShadowRenderer.m_253170_(vertexConsumer5, matrix4f, q);
                VoidShadowRenderer.m_252912_(vertexConsumer5, matrix4f, o, p);
                VoidShadowRenderer.m_253012_(vertexConsumer5, matrix4f, o, p);
                VoidShadowRenderer.m_253170_(vertexConsumer5, matrix4f, q);
                VoidShadowRenderer.m_253012_(vertexConsumer5, matrix4f, o, p);
                VoidShadowRenderer.m_252736_(vertexConsumer5, matrix4f, o, p);
                VoidShadowRenderer.m_253170_(vertexConsumer5, matrix4f, q);
                VoidShadowRenderer.m_252736_(vertexConsumer5, matrix4f, o, p);
                VoidShadowRenderer.m_252912_(vertexConsumer5, matrix4f, o, p);
                ++n;
            }
            matrixStack.m_85849_();
        }
        super.m_7392_((Mob)voidShadowEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    private static void m_253170_(VertexConsumer vertices, Matrix4f matrix, int alpha) {
        vertices.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(36, 0, 90, alpha).m_5752_();
    }

    private static void m_252912_(VertexConsumer vertices, Matrix4f matrix, float y, float x) {
        vertices.m_252986_(matrix, -((float)(Math.sqrt(3.0) / 2.0)) * x, y, -0.5f * x).m_6122_(36, 0, 90, 0).m_5752_();
    }

    private static void m_253012_(VertexConsumer vertices, Matrix4f matrix, float y, float x) {
        vertices.m_252986_(matrix, (float)(Math.sqrt(3.0) / 2.0) * x, y, -0.5f * x).m_6122_(36, 0, 90, 0).m_5752_();
    }

    private static void m_252736_(VertexConsumer vertices, Matrix4f matrix, float y, float z) {
        vertices.m_252986_(matrix, 0.0f, y, 1.0f * z).m_6122_(36, 0, 90, 0).m_5752_();
    }
}

